<%*
const clip = '' + await tp.system.clipboard();
const nums = clip.match(/-?\d+(?:\.\d+)?/g) ?? [];
const lat = nums[0];
const lon = nums[1];

if (!lat || !lon) {
  new Notice("Keine gültigen Koordinaten im Clipboard gefunden");
  return;
}

let stadt = "";
let region = "";
let land = "";

try {
  const url =
    `https://nominatim.openstreetmap.org/reverse?format=jsonv2` +
    `&lat=${encodeURIComponent(lat)}` +
    `&lon=${encodeURIComponent(lon)}` +
    `&zoom=18&addressdetails=1`;

  const res = await requestUrl({
    url,
    method: "GET",
    headers: { "User-Agent": "Obsidian-Templater" }
  });

  const data = res.json;
  const a = data?.address ?? {};

  stadt = a.city || a.town || a.village || a.hamlet || "";
  region = a.state || a.region || a.county || "";
  land = a.country || "";

} catch (e) {
  console.error(e);
  new Notice("Adresse konnte nicht geladen werden");
}

const file = tp.file.find_tfile(tp.file.path(true));

await app.fileManager.processFrontMatter(file, (frontmatter) => {
  frontmatter.coordinates = [lat, lon];
  if (stadt) frontmatter.stadt = stadt;
  if (region) frontmatter.region = region;
  if (land) frontmatter.land = land;
});

new Notice("Koordinaten und Ortsdaten wurden gesetzt");
%>